import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.*;
//import java.util.Vector;

// TODO: Fix the route check, totally n00by with 4 redundant functions..

public class MyAi extends Client {
	private int getStateCounter = 0;
	private int timeSinceLastState = 0;
	private int sleepTime = 125;
	private float myVapor;

	private Cloud cloud;
	private Cloud myCloud;
        
	private ArrayList<Cloud> allClouds;
	

    private Vector wind;
    private Vector avoidDir;

	private int mode = 0;
	
	private static int AVOIDANCE = 1;
	private static int SURVIVAL = 2;

    private static float WIND_CRITICAL = 200.0F;
    private static float WIND_LOW = 400.0F;
    private static float WIND_NORMAL = 600.0F;
    private static float WIND_HIGH = 950.0F;


        // windFactor is determined by the current Wind level (see above floats).
   // private float windFactor;


    public MyAi() throws IOException, InterruptedException {
        super();

    }

    // Implement your AI here
    // Use these functions to communicate with server:
    //    SetName(name) - Sets your name to appear in the simulator
    //    GetState() - returns the current GameState object
    //    Wind(x, y) - applies a wind in the given direction (returns true if OK, false if IGNORED)
    @Override
    public void RunAi() throws IOException, InterruptedException {
        SetName("ISwallowAI");

        allClouds = new ArrayList< Cloud>();

        wind = new Vector( 0.0F, 0.0F );

        //windFactor = 0.0F;


        while (Connected()) {
			
            GameState state = GetState();

            getStateCounter++;


            if (state == null) break;

            myCloud = state.Me();

            mode = AVOIDANCE;


            for( int i = 0; i < state.Thunderstorms.size(); i++ ) {
                cloud = state.Thunderstorms.get(i);

                if( cloud != null && cloud != state.Me() ) {

                    allClouds.add( cloud );
                }

            }


            for( int i = 0; i < state.Rainclouds.size(); i++ ) {
                cloud = state.Rainclouds.get(i);

                if( cloud != null ) {

                    allClouds.add( cloud );
                }

            }



            if( myCloud.Velocity.x == 0.0F && myCloud.Velocity.y == 0.0F )
                //Wind( (float) myCloud.Position.x * 0.11F, (float) myCloud.Position.y * 0.12F );
                Wind((float) Math.random() * 14 - 50, (float) Math.random() * 7 - 50);

                doCommand();

            sleepTime = 125;
            //}
        timeSinceLastState += sleepTime;
        Thread.sleep(sleepTime);
        }
    }



	public int timeToPoint( float distance, Vector vel ) {
	    // TODO: Add logic to find out time it takes for vector to reach distance on current velocity.

	    return 1;
	
	}

    /* Function that calculates and performs the AI's next move.
     *
     **/

    public void doCommand() {
        Cloud cld = myCloud;
        int facingDir = 0;            // -1 = -180-0 degrees | 1 = 0 - 180 degrees.

        Vector windDir = new Vector(1.0F, 1.0F);

                // NORTHEAST direction
        if( myCloud.Velocity.x > 0 && myCloud.Velocity.y > 0)
            cld = checkNERoute( cld );
            facingDir = 1;

               // NORTHWEST direction
        if( myCloud.Velocity.x < 0 && myCloud.Velocity.y > 0 )
            cld = checkNWRoute( cld );
            facingDir = -1;

               // SOUTHEAST direction
        if( myCloud.Velocity.x > 0 && myCloud.Velocity.y < 0 )
            cld = checkSERoute( cld );
            facingDir = 1;

              // SOUTHWEST direction
        if( myCloud.Velocity.x < 0 && myCloud.Velocity.y < 0 )
            cld = checkSWRoute( cld );
            facingDir = -1;

        // TODO: Implement modesystem, now it's hardcoded with mandatory avoidance.

            // If route is not clear of dangerous clouds, change direction.
            // else check speed and vapor and do maintenance wind if necessary

            // Note:  The collision cloud cld is returned to do calculations relative to its pos and vel if necessary.

        float magnitude = myCloud.Velocity.length();

        if( cld != null ) {
            if( facingDir > 0 ) {
                windDir.x = (float) ((float) myCloud.Velocity.x * Math.cos( Math.PI / 2 ) * -1.0F - myCloud.Velocity.y * Math.sin( Math.PI / 2 )) * magnitude;
                windDir.y = (float) ((float) myCloud.Velocity.x * Math.sin( Math.PI / 2 ) * -1.0F - myCloud.Velocity.y * Math.cos( Math.PI / 2 )) * magnitude;
            }

            if( facingDir > 0 ) {
                windDir.x = (float) ((float) myCloud.Velocity.x * Math.cos( Math.PI / 2 ) * -1.0F - myCloud.Velocity.y * Math.sin( Math.PI / 2 ));
                windDir.y = (float) ((float) myCloud.Velocity.x * Math.sin( Math.PI / 2 ) * -1.0F - myCloud.Velocity.y * Math.cos( Math.PI / 2 ));
            }


            System.out.println( "\nwinDir.x = " + windDir.x );
            System.out.println( "\nwinDir.y = " + windDir.y );

            calculateWind( windDir,  cld );

        } else {
            // At the moment do nothing and maintain same speed.
            calculateWind( myCloud.Velocity, null );
        }

    }

    /*
     * Calculates and exectues the Wind command according to certain criteria.
     *
     *  PARAMS:
     *    dir - the direction the wind is to blow in.
     *    cld - if not null, defines an opposing Cloud bigger than myCloud in its current path.
     */
    public void calculateWind( Vector dir, Cloud cld ) {
        Vector temp = new Vector(1.0F, 1.0F);

            // No change in direction, maintain speed / increase.
        if( cld == null ) {
            if( myCloud.Vapor >= 600.0F ) {
                temp.x = 0.20F * myCloud.Velocity.x;
                temp.y = myCloud.Position.x / 0.17F + 0.30F * myCloud.Velocity.y;

                try {
                    Wind( temp.x, temp.y );
                } catch (IOException e) {
                    e.printStackTrace();  //To change body of catch statement use File | Settings | File Templates.
                }
            }

        } else {

            if( myCloud.Vapor >= 400.0F  ) {
                temp = dir;

                temp.x = (temp.x * myCloud.Velocity.x) * 0.40F * -1.0F;
                temp.y = (temp.y * myCloud.Velocity.y) * 0.42F;

                try {
                    Wind( temp.x, temp.y );
                } catch (IOException e) {
                    e.printStackTrace();  //To change body of catch statement use File | Settings | File Templates.
                }
            } else {
                temp = dir;

                temp.x = (temp.x * myCloud.Velocity.x) * 0.45F;
                temp.y = (temp.y * myCloud.Velocity.y) * 0.37F * -1.0F;

                try {
                    Wind( temp.x, temp.y );
                } catch (IOException e) {
                    e.printStackTrace();  //To change body of catch statement use File | Settings | File Templates.
                }
            }


        }



    }

    public Cloud checkNERoute( Cloud cld ) {
        boolean notHitWall = true;

        while( notHitWall )  {
            cld.Position.add( cld.Velocity );

            for( int i = 0; i < allClouds.size(); i++ ) {
                cloud = allClouds.get(i);

                   // Check if cloud on collision course is bigger than myCloud (note: smaller and equal clouds are ignored).
                   // TODO: This should really be tackled with heuristics in terms of probability of it being bigger / smaller when the actual collision occurs.
                if( checkCollision( cld, cloud ) && cld.Vapor < cloud.Vapor ) {
                    return cld;
                }

            }

            if( cld.Position.x > 1280 )
                notHitWall = false;
            else if( cld.Position.y > 720 )
                notHitWall = false;

        }

        return null;
    }

    public Cloud checkNWRoute( Cloud cld ) {
        boolean notHitWall = true;

        while( notHitWall )  {
            cld.Position.add( cld.Velocity );

            for( int i = 0; i < allClouds.size(); i++ ) {
                cloud = allClouds.get(i);

                   // Check if cloud on collision course is bigger than myCloud (note: smaller and equal clouds are ignored).
                   // TODO: This should really be tackled with heuristics in terms of probability of it being bigger / smaller when the actual collision occurs.
                if( checkCollision( cld, cloud ) && cld.Vapor < cloud.Vapor ) {
                    return cld;
                }

            }

            if( cld.Position.x < 0 )
                notHitWall = false;
            else if( cld.Position.y > 720 )
                notHitWall = false;

        }

        return null;
    }

    public Cloud checkSERoute( Cloud cld ) {
        boolean notHitWall = true;

        while( notHitWall )  {
            cld.Position.add( cld.Velocity );

            for( int i = 0; i < allClouds.size(); i++ ) {
                cloud = allClouds.get(i);

                   // Check if cloud on collision course is bigger than myCloud (note: smaller and equal clouds are ignored).
                   // TODO: This should really be tackled with heuristics in terms of probability of it being bigger / smaller when the actual collision occurs.
                if( checkCollision( cld, cloud ) && cld.Vapor < cloud.Vapor ) {
                    return cld;
                }

            }

            if( cld.Position.x > 1280 )
                notHitWall = false;
            else if( cld.Position.y < 0 )
                notHitWall = false;

        }

        return null;
    }

    public Cloud checkSWRoute( Cloud cld ) {
        boolean notHitWall = true;

        while( notHitWall )  {
            cld.Position.add( cld.Velocity );

            for( int i = 0; i < allClouds.size(); i++ ) {
                cloud = allClouds.get(i);

                   // Check if cloud on collision course is bigger than myCloud (note: smaller and equal clouds are ignored).
                   // TODO: This should really be tackled with heuristics in terms of probability of it being bigger / smaller when the actual collision occurs.
                if( checkCollision( cld, cloud ) && cld.Vapor < cloud.Vapor ) {
                    return cld;
                }

            }

            if( cld.Position.x < 1280 )
                notHitWall = false;
            else if( cld.Position.y < 0 )
                notHitWall = false;

        }

        return null;
    }
    public boolean checkCollision( Cloud A, Cloud B ) {
            // Checks to see if the sum of the radii are < or > than the distance
            // between the circle centers
        if( A.Position.getDistance( B.Position ) < ( A.Radius() + B.Radius() ) ) {
            return true;
        }

        return false;
    }



    /*
        Checks current vaporlevel and sets windfactor.
        Rest of the program only concerns itself about the desired action, windFactor can however be overridden in
        special circumstances; if more precision is necessary.

        Note: windFactor is updated in addition to being returned, for convenience. EDIT: Update removed.

        return WindFactor
     */
    public float calculateWindFactor() {
        float windFactor;

        if( myCloud.Vapor < WIND_LOW ) {
            windFactor = 0.1F;

        } else if( myCloud.Vapor < WIND_NORMAL ) {
            windFactor = 0.2F;

        } else if( myCloud.Vapor < WIND_HIGH ) {
            windFactor = 0.7F;
        } else
            windFactor = 1.2F;

        return windFactor;

    }

    public static void main(String[] args) {
        try {
            MyAi ai = new MyAi();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

}


/*
TODO:
  - Fill map with x, y map coordinates of clouds and the designated cloud
  - Make checking loop with radius + movements in moving direction to end of screen
  - If hit, do command
  - If not hit, but calculated speed vs vapor vs target is too little, checkif wind can be used
    (if vapor size is not too low).

Suggestion:

     Calculate vector direction by angle and check radius sized portions for collision through direction.


S #2:

   Construct check curDir func thtat stops on first collidable object and returns it.
   A new direction then have be calculated (+ / - 90 degrees), wind is measured first by need and then limited to save vapor.
   (HARD: Calculate if vapor use can be limited due to cur vel high enough to get away).


*/


/*TEMP CODE:



 */











